//
//  YHApproverInfoVerifyCell.swift
//  galaxy
//
//  Created by edy on 2024/8/16.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHApproverInfoVerifyCell: UITableViewCell {

    static let cellReuseIdentifier = "YHApproverInfoVerifyCell"

    var familyArr:[YHApplicantInfoModel] = []
    var familyGroupInfo: YHFamilyGroupModel = YHFamilyGroupModel()

    let memberRowHeight = 69.0
    
    func updateFamilyArr(_ familyArr: [YHApplicantInfoModel], familyGroup:YHFamilyGroupModel) {
        self.familyArr = familyArr
        self.familyGroupInfo = familyGroup
        tableView.snp.updateConstraints { make in
            make.height.equalTo(memberRowHeight * Double(familyArr.count) + 4.0)
        }
        self.tableView.reloadData()
    }
    
    lazy var whiteContentView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.layer.cornerRadius = kCornerRadius6
        return view
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        // 标题
        var title: ASAttributedString = .init("获批者信息核实", .font(UIFont.PFSC_M(ofSize: 17)),.foreground(UIColor.mainTextColor))
        // 是否必填
        if true {
            let mustTag: ASAttributedString = .init("*", .font(UIFont.PFSC_M(ofSize: 17)),.foreground(UIColor.failColor))
            title = mustTag + title
        }
        label.attributed.text = title
        return label
    }()
    
    lazy var tableView: UITableView = {
        let tableView = UITableView(frame: CGRect.zero, style:.grouped)
        if #available(iOS 15.0, *) {
           tableView.sectionHeaderTopPadding = 0.0
        }
        tableView.estimatedSectionHeaderHeight = 0.1
        tableView.estimatedSectionFooterHeight = 0.1
        tableView.contentInsetAdjustmentBehavior = .never
        tableView.showsVerticalScrollIndicator = false
        tableView.backgroundColor = .clear
        tableView.separatorStyle = .none
        tableView.bounces = false
        tableView.register(YHFamilyMemberInfoCell.self, forCellReuseIdentifier: YHFamilyMemberInfoCell.cellReuseIdentifier)
        tableView.delegate = self
        tableView.dataSource = self
        tableView.isScrollEnabled = false
        return tableView
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        self.selectionStyle = .none
        self.backgroundColor = .clear
        self.contentView.backgroundColor = .clear
        contentView.addSubview(whiteContentView)
        whiteContentView.addSubview(titleLabel)
        whiteContentView.addSubview(tableView)
        
        whiteContentView.snp.makeConstraints { make in
            make.top.bottom.equalToSuperview()
            make.left.equalTo(16)
            make.right.equalTo(-16)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(16)
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.height.equalTo(24)
        }
        
        tableView.snp.makeConstraints { make in
            make.top.equalTo(titleLabel.snp.bottom).offset(12)
            make.height.equalTo(0)
            make.left.right.bottom.equalToSuperview()
        }
        tableView.reloadData()
    }
}

extension YHApproverInfoVerifyCell: UITableViewDelegate, UITableViewDataSource {
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return familyArr.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        
        let cell = tableView.dequeueReusableCell(withIdentifier: YHFamilyMemberInfoCell.cellReuseIdentifier, for: indexPath) as! YHFamilyMemberInfoCell
        
        if 0 <= indexPath.row && indexPath.row < familyArr.count {
            let model = familyArr[indexPath.row]
            cell.updateModel(model)
        }
        return cell
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return 69.0
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        
        if 0 <= indexPath.row && indexPath.row < familyArr.count {
            let model = familyArr[indexPath.row]
            let vc = YHFamilyInfoUpdateViewController()
            vc.detailMember = model
            vc.orderId = self.familyGroupInfo.orderid
            UIViewController.current?.navigationController?.pushViewController(vc)
        }
    }
    
    private func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> CGFloat {
        return 0.1
    }
    
    private func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> CGFloat {
        return 0.1
    }
    
    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        let view = UIView()
        return view
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        let view = UIView()
        return view
    }
}
